<?php
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */


    class VisualizzatoreVideo extends VisualizzatoreComponente {
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            $impostazioniVideo = parent::getDb()->leggiSingolaRiga("geec_video",$dati["idElemento"]);
            
            if($impostazioniVideo["animazioneTesto"]) {
                $codiceAnimazione = "data-aos=\"{$impostazioniVideo["animazioneTesto"]}\"";
            }
            else {
                $codiceAnimazione = "";
            }

            echo "<div class=\"{$impostazioniVideo["spazioOccupato"]}\">
                    {$this->generaCodiceVideo($impostazioniVideo)}
                </div>";
        }
       
        function generaCodiceVideo($impostazioniVideo) {
            if($impostazioniVideo["animazioneVideo"]) {
                $codiceAnimazione = "data-aos=\"{$impostazioniVideo["animazioneVideo"]}\"";
            }
            else {
                $codiceAnimazione = "";
            }
            
            if(strpos($impostazioniVideo["video"],"https")!=0) {       
                return "<div class=\"embed-responsive embed-responsive-16by9\">
                      <video controls $codiceAnimazione >
                        <source src=\"{$impostazioniVideo["video"]}\" type=\"video/mp4\">
                        Il tuo browser non supporta il tag video.
                      </video>
                    </div>";
            }
            else {
                return "<div class=\"embed-responsive embed-responsive-16by9\" $codiceAnimazione>
                            <iframe class=\"embed-responsive-item\" src=\"{$impostazioniVideo["video"]}\" allowfullscreen></iframe>
                        </div>";
            }
        }
    }